import { View, Text } from "react-native";
import React from "react";
import styles from "./AverageReviewsStyles";
import CustomRating from "../../../../../screens/Utilities/CustomRating/CustomRating";
import dpr from "../../../../../screens/Utilities/CustomStyleAttribute/dpr";
import { round } from "../../../../../helper/ratingRound";
import useLangTranslation from "../../../../../hooks/useLangTranslation";

const AverageReviews = ({review}) => {
    const { trans } = useLangTranslation();
    return (
        <View style={styles.reviewsShortView}>
            <Text style={styles.rating}>
                {round(review?.avg) || 0}
            </Text>
            <View style={styles.stars}>
                <CustomRating rating={review?.avg} starSize={dpr(24)} />
            </View>
            <Text style={styles.averageText}>
                {trans("Average of {{x}} reviews", {x: review?.reviewCount})}
            </Text>
        </View>
    );
};

export default AverageReviews;
